--
-- `#prefix#Groups`
--
CREATE TABLE IF NOT EXISTS `#prefix#Groups` (
    `id`         int(10) unsigned NOT NULL AUTO_INCREMENT,
    `name`       VARCHAR(255) NOT NULL,
    `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
    `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
    PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=#charset# DEFAULT COLLATE #collation#;

--
-- `#prefix#Resellers`
--
CREATE TABLE IF NOT EXISTS `#prefix#Resellers` (
    `id`            int(10) unsigned NOT NULL AUTO_INCREMENT,
    `groupid`       int(10) unsigned NOT NULL,
    `clientid`      int(10) unsigned NOT NULL,
    PRIMARY KEY (`id`),
    FOREIGN KEY (`groupid`) REFERENCES `#prefix#Groups` (`id`) ON DELETE CASCADE,
    KEY `groupid` (`groupid`),
    KEY `clientid` (`clientid`)
) ENGINE=InnoDB DEFAULT CHARSET=#charset# DEFAULT COLLATE #collation#;

--
-- `#prefix#ResellerSettings`
--
CREATE TABLE IF NOT EXISTS `#prefix#ResellerSettings` (
    `resellerid`    int(10) unsigned NOT NULL,
    `setting`       VARCHAR(255) NOT NULL,
    `value`         TEXT NOT NULL,
    PRIMARY KEY (`resellerid`, `setting`),
    FOREIGN KEY (`resellerid`) REFERENCES `#prefix#Resellers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=#charset# DEFAULT COLLATE #collation#;

--
-- `#prefix#ResellerRelations`
--
CREATE TABLE IF NOT EXISTS `#prefix#ResellerRelations` (
    `id`            int(10) unsigned NOT NULL AUTO_INCREMENT,
    `resellerid`    int(10) unsigned NOT NULL,
    `relid`         int(10) NOT NULL,
    `type`          enum('domain') NOT NULL,
    PRIMARY KEY (`id`),
    FOREIGN KEY (`resellerid`) REFERENCES `#prefix#Resellers` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=#charset# DEFAULT COLLATE #collation#;

--
-- `#prefix#Groups`
--
CREATE TABLE IF NOT EXISTS `#prefix#GroupSettings` (
    `groupid` int(10) unsigned NOT NULL AUTO_INCREMENT,
    `setting` VARCHAR(255) NOT NULL,
    `value`   TEXT NOT NULL,
    PRIMARY KEY (`groupid`, `setting`),
    FOREIGN KEY (`groupid`) REFERENCES `#prefix#Groups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=#charset# DEFAULT COLLATE #collation#;

--
-- `#prefix#GroupProducts`
--
CREATE TABLE IF NOT EXISTS `#prefix#GroupProducts` (
    `id`      int(10) unsigned NOT NULL AUTO_INCREMENT,
    `groupid` int(10) unsigned NOT NULL,
    `relid`   int(10) NOT NULL,
    `type`    enum('domainregister', 'domaintransfer', 'domainrenew') NOT NULL,
    `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
    `updated_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
    PRIMARY KEY (`id`),
    FOREIGN KEY (`groupid`) REFERENCES `#prefix#Groups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=#charset# DEFAULT COLLATE #collation#;

--
-- `#prefix#Pricing`
--
CREATE TABLE IF NOT EXISTS `#prefix#Pricing` (
    `relid`         int(10) unsigned NOT NULL,
    `currencyid`    int(10) NOT NULL,
    `billingcycle`  VARCHAR(255) NOT NULL,
    `value`         VARCHAR(255) NOT NULL,
    PRIMARY KEY (`relid`, `currencyid`, `billingcycle`),
    FOREIGN KEY (`relid`) REFERENCES `#prefix#GroupProducts` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=#charset# DEFAULT COLLATE #collation#;

--
-- `#prefix#Submodules`
--
CREATE TABLE IF NOT EXISTS `#prefix#Submodules` (
    `id`               int(10) NOT NULL AUTO_INCREMENT,
    `groupid`          int(10) unsigned NOT NULL,
    `name`             VARCHAR(64) NOT NULL,
    `type`             enum('whmcs', 'blesta') NOT NULL,
    `additionalFields` enum('on', 'off') DEFAULT 'off',
    `description`      TEXT,
    `logo`             TEXT,
    `documentation`    TEXT,
    `path`             TEXT,
    `created_at`    timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
    PRIMARY KEY (`id`),
    FOREIGN KEY (`groupid`) REFERENCES `#prefix#Groups` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=#charset# DEFAULT COLLATE #collation#;

--
-- `#prefix#DomainContacts`
--
CREATE TABLE IF NOT EXISTS `#prefix#DomainContacts` (
    `domainid` int(10) NOT NULL AUTO_INCREMENT,
    `type`    enum('tech', 'admin', 'billing', 'registrant'),
    `field`   VARCHAR(255) NOT NULL,
    `value`   TEXT NOT NULL,
    PRIMARY KEY (`domainid`, `type`, `field`)
) ENGINE=InnoDB DEFAULT CHARSET=#charset# DEFAULT COLLATE #collation#;

--
-- `#prefix#ResponseTemplates`
--
CREATE TABLE IF NOT EXISTS `#prefix#ResponseTemplates` (
   `id` int(10) NOT NULL AUTO_INCREMENT,
   `search` TEXT,
   `replacement` TEXT,
   `type` enum('text', 'regexp') NOT NULL,
   `action` VARCHAR(255) NOT NULL,
   `priority` int(10) DEFAULT NULL,
   `enable` tinyint(1) DEFAULT 1,
   PRIMARY KEY (`id`),
   KEY `action` (`action`)
) ENGINE=InnoDB DEFAULT CHARSET=#charset# DEFAULT COLLATE #collation#;

CREATE TABLE IF NOT EXISTS `#prefix#DomainOriginalParams` (
    `domainid` int(10) NOT NULL AUTO_INCREMENT,
    `data`    TEXT,
    PRIMARY KEY (`domainid`)
) ENGINE=InnoDB DEFAULT CHARSET=#charset# DEFAULT COLLATE #collation#;
